#!/usr/bin/python
# -*- coding: utf-8  -*-

"""
This bot goes over images, converting from bmp to jpg

"Diet for Images ;-)"

This script understands various command-line arguments:

	-start:		used as -start:page_name, specifies that the robot should
				   go alphabetically through all pages on the home wiki,
				   starting at the named page.

	-file:		 used as -file:file_name, read a list of pages to treat
				   from the named textfile. Page titles should be enclosed
				   in [[double-squared brackets]].

	-ref:		  used as -start:page_name, specifies that the robot should
				   touch all pages referring to the named page.

	-links:		used as -links:page_name, specifies that the robot should
				   touch all pages referred to from the named page.

	-cat:		  used as -cat:category_name, specifies that the robot should
				   touch all pages in the named category.

	-redir		 specifies that the robot should touch redirect pages;
				   otherwise, they will be skipped.

All other parameters will be regarded as a page title; in this case, the bot
will only touch a single page.
"""

__version__='$Id: imageless.py,v 1.13 2007/01/24 01:02:06 wendel Exp $'

import wikipedia, pagegenerators, catlib
import sys
import re
from upload import UploadRobot
import os
import urllib2

msg={
	'en':u'FatImage article bot',
	'pt':u'[fatimages.py] Dieta para imagens obesas',
}

class ImageBot:
	def __init__(self, generator, touch_redirects, confirm_edits, first_image, reload_anyway):
		self.generator = generator
		self.touch_redirects = touch_redirects
		self.confirm_edits = confirm_edits
		self.first_image = first_image
		self.reload_anyway = reload_anyway

	def confirm(self):
		if self.confirm_edits:
			answer = wikipedia.input('Perform edits ? [Y/n]')
			if answer == 'n':
				return False
		return True
	
	def getImage(self, imageUrl, imageFilename):
		imageContent = urllib2.urlopen(imageUrl)
		imageFile = open(imageFilename, "wb")
		hasData = True
		size = 0
		while hasData:
			buffer = imageContent.read(131072)
			if buffer == "":
				hasData = False
			else:
				imageFile.write(buffer)
				size = size + len(buffer)
				print " -> %d bytes" % size
	
		imageFile.close()

	def getImage2(self, imageUrl, imageFilename):
		request = urllib2.Request(imageUrl)
		opener = urllib2.build_opener()
		firstdatastream = opener.open(request)
		request.add_header('If-Modified-Since', 'Thu, 01 Apr 2000 01:02:03 GMT')
		request.add_header('If-None-Match', '1bd87f6-19676-4675daa5')
		request.add_header('Cache-Control', 'max-age=0')
		imageContent = opener.open(request)
		imageFile = open(imageFilename, "wb")
		hasData = True
		size = 0
		while hasData:
			buffer = imageContent.read(131072)
			if buffer == "":
				hasData = False
			else:
				imageFile.write(buffer)
				size = size + len(buffer)
				print " -> %d bytes" % size
	
		imageFile.close()
		
	def run(self):
		mysite = wikipedia.getSite()
		wikipedia.setAction(wikipedia.translate(mysite,msg))
		skip = False
		if self.first_image != None:
			skip = True

		counter = 0
		for page in self.generator:
			try:
				print "Reading article: %s" % page.title()
				for image in page.imagelinks():
					counter = counter + 1
					print "%5d. Reading image: %s" % (counter, image.title())
					if skip:
						if image.title().split(':')[1] == self.first_image:
							skip = False
						else:
							continue
					try:
						imageFilename = image.title().split(':')[1]
						imageExtension = image.title().split('.')[-1].lower()
						if imageExtension != 'bmp' and (image.getImagePageHtml().find('image/x-ms-bmp') >= 0 or image.getImagePageHtml().find('image/x-bmp') >= 0):
							print "Hey! It's a bmp!"
							imageUrl = image.fileUrl()
							self.getImage(imageUrl, "/tmp/fatimages.bmp")
							
							if os.system('./dietimage.sh %s' % imageExtension) == 0:
								print "Image is fat-free now! Uploading..."
								uploader = UploadRobot(u"file:///tmp/fatimages.%s" % imageExtension, ignoreWarning = True, useFilename = imageFilename, keepFilename = True, verifyDescription = False)
								uploader.upload_image()
								print "Trying to reload %s..." % imageUrl
								self.getImage2(imageUrl, "/dev/null")
								imageText = image.get()
								if (imageText.find("OBESAS") == -1):
									print "Adding Category"
									imageText = imageText + "\n[[Categoria:FOTOS OBESAS]]"
									image.put(imageText)
								print "Done!"
						elif imageExtension != 'bmp' and self.reload_anyway:
							imageUrl = image.fileUrl()
							print "Reloading %s for the sake of reloading..." % imageUrl
							try:
								self.getImage2(imageUrl, "/dev/null")
							except urllib2.HTTPError:
								print "File not found O_o"
							print "Done!"
					except wikipedia.NoPage:
						print "Page %s does not exist?!" % page.aslink()
					except wikipedia.IsRedirectPage:
						print "Page %s is a redirect; skipping." % page.aslink()
					except wikipedia.LockedPage:
						print "Page %s is locked?!" % page.aslink()

			except wikipedia.NoPage:
				print "Page %s does not exist?!" % page.aslink()
			except wikipedia.IsRedirectPage:
				print "Page %s is a redirect; skipping." % page.aslink()
			except wikipedia.LockedPage:
				print "Page %s is locked?!" % page.aslink()

def main():
	#page generator
	gen = None
	redirs = False
	confirm = False
	firstimage = None
	reload_anyway = False
	pageTitle = []
	for arg in wikipedia.handleArgs():
		if arg.startswith('-start:'):
			page = wikipedia.Page(wikipedia.getSite(),arg[7:])
			gen = pagegenerators.AllpagesPageGenerator(page.titleWithoutNamespace(),namespace=page.namespace())
		elif arg.startswith('-ref:'):
			referredPage = wikipedia.Page(wikipedia.getSite(), arg[5:])
			gen = pagegenerators.ReferringPageGenerator(referredPage)
		elif arg.startswith('-links:'):
			linkingPage = wikipedia.Page(wikipedia.getSite(), arg[7:])
			gen = pagegenerators.LinkedPageGenerator(linkingPage)
		elif arg.startswith('-file:'):
			gen = pagegenerators.TextfilePageGenerator(arg[6:])
		elif arg.startswith('-cat:'):
			cat = catlib.Category(wikipedia.getSite(), arg[5:])
			gen = pagegenerators.CategorizedPageGenerator(cat)
		elif arg.startswith('-redir'):
			redirs = True
		elif arg.startswith('-confirm'):
			confirm = True
		elif arg.startswith('-startwith:'):
			firstimage = arg[11:]
		elif arg.startswith('-reload'):
			reload_anyway = True
		else:
			pageTitle.append(arg)

	if pageTitle:
		page = wikipedia.Page(wikipedia.getSite(), ' '.join(pageTitle))
		gen = iter([page])
	if not gen:
		wikipedia.showHelp('fatimages')
	else:
		preloadingGen = pagegenerators.PreloadingGenerator(gen)
		bot = ImageBot(preloadingGen, redirs, confirm, firstimage, reload_anyway)
		bot.run()

if __name__ == "__main__":
	try:
		main()
	finally:
		wikipedia.stopme()
