# -*- coding: utf-8  -*-
import family
    
# The Uncyclopaedia family, a satirical set of encyclopaedia wikis.
#        
#

class Family(family.Family):
    def __init__(self):
        family.Family.__init__(self)
        self.name = 'uncyclopedia'
    
        self.langs = {
	    'ar': 'beidipedia.wikia.com',
            'ast': 'nunyepedia.wikia.com', # TODO
            'ca': 'valenciclopedia.wikia.com',
            'cs': 'necyklo.pedie.info',
            'da': 'da.uncyclopedia.wikia.com',
            'de': 'de.uncyclopedia.wikia.com',
            'el': 'frikipaideia.wikia.com', # was 'anegkyklopaideia.wikia.com'
            'en': 'uncyclopedia.org',
            'es': 'inciclopedia.wikia.com',
            'fa': 'fa.uncyclopaedia.org', # TODO
            'fi': 'hiki.pedia.ws',
            'fr': 'desencyclopedie.wikia.com',
	    'he': 'eincyclopedia.wikia.com',
            'hu': 'hu.uncyclopedia.info',
	    'it': 'nonciclopedia.wikia.com',
            'ja': 'ja.uncyclopedia.info',
            'ko': 'ko.uncyclopedia.info',
	    'la': 'uncapaedia.wikia.com',
            'nl': 'onziclo.pedie.info',
            'nn': 'ikke.pedia.ws',
            'no': 'ikkepedia.wikia.com',
            'pl': 'nonsensopedia.wikia.com',
            'pt': 'desciclo.pedia.ws',
            'ru': 'absurdopedia.wikia.com',
            'sr': 'sr.uncyc.org',
	    'sv': 'psyklopedin.hehu.se',
            'th': 'th.uncyclopedia.info', # TODO
            'tr': 'yansiklo.pedia.ws', # TODO
	    'zh': 'zh.uncyclopedia.wikia.com',
            'zh-tw': 'zh.uncyclopedia.info',
            }
    
        # Most namespaces are inherited from family.Family.
        self.namespaces[1] = {
            '_default': u'Talk',
            'ar': u'نقاش',
	    'ca': u'Discussió',
            'cs': u'Diskuse',
	    'da': u'Diskussion',
            'de': u'Diskussion',
            'el': u'Συζήτηση',
            'en': u'Talk',
	    'es': u'Discusión',
	    'fi': u'Keskustelu',
            'fr': u'Discuter',
            'he': u'שיחה',
	    'it': u'Discussione',
            'ko': u'토론',
	    'la': u'Disputatio',
            'nl': u'Overleg',
	    'nn': u'Diskusjon',
	    'no': u'Diskusjon',
            'pl': u'Dyskusja',
            'pt': u'Discussão',
            'ru': u'Обсуждение',
            'sr': u'Разговор',
	    'sv': u'Diskussion',
            'zh-tw': u'討論',
	}

        self.namespaces[2] = {
            '_default': u'User',
            'ar': u'مستخدم',
	    'ca': u'Usuari',
            'cs': u'Uživatel',
            'da': u'Bruger',
            'de': u'Benutzer',
            'el': u'Χρήστης',
            'en': u'User',
	    'es': u'Usuario',
	    'fi': u'Käyttäjä',
            'fr': u'Utilisateur',
            'he': u'משתמש',
	    'it': u'Utente',
            'ko': u'사용자',
	    'la': u'Usor',
            'nl': u'Gebruiker',
	    'nn': u'Bruker',
	    'no': u'Bruker',
            'pl': u'Użytkownik',
            'pt': u'Usuário',
            'ru': u'Участник',
            'sr': u'Корисник',
	    'sv': u'Användare',
	    'zh-tw': u'用戶',
        }

        self.namespaces[3] = {
            '_default': u'User talk',
            'ar': u'نقاش المستخدم',
	    'ca': u'Usuari Discussió',
            'cs': u'Uživatel diskuse',
            'da': u'Bruger diskussion',
            'de': u'Benutzer Diskussion',
            'el': u'Συζήτηση χρήστη',
            'en': u'User talk',
	    'es': u'Usuario Discusión',
	    'fi': u'Keskustelu käyttäjästä',
            'fr': u'Discussion Utilisateur',
            'he': u'שיחת משתמש',
	    'it': u'Discussioni utente',
            'ko': u'사용자토론',
	    'la': u'Disputatio Usoris',
            'nl': u'Overleg gebruiker',
	    'nn': u'Brukerdiskusjon',
	    'no': u'Brukerdiskusjon',
            'pl': u'Dyskusja użytkownika',
            'pt': u'Usuário Discussão',
            'ru': u'Обсуждение участника',
            'sr': u'Разговор са корисником',
	    'sv': u'Användardiskussion',
	    'zh-tw': u'用戶討論',
        }

        self.namespaces[4] = {
            '_default': u'Uncyclopedia',
	    'ar': u'ويكيبيديا',
	    'ca': u'Valenciclopèdia',
            'cs': u'Necyklopedie',
            'da': u'Spademanns Leksikon',
            'de': u'Uncyclopedia',
	    'el': u'Φρικηπαίδεια',
            'en': u'Uncyclopedia',
            'es': u'Inciclopedia',
	    'fi': u'Hikipedia',
            'fr': u'Désencyclopédie',
            'he': u'איןציקלופדיה',
	    'it': u'Nonciclopedia',
            'ko': u'Uncyclopedia',
	    'la': u'Uncapaedia',
	    'nl': u'Onziclopedie',
	    'nn': u'Ikkepedia',
	    'no': u'Ikkepedia',
            'pl': u'Nonsensopedia',
            'pt': u'Desciclopédia',
	    'ru': u'Абсурдопедия',
            'sr': u'Нециклопедија',
	    'sv': u'Psyklopedin',
	    'zh': u'伪基百科',
	    'zh-tw': u'偽基百科',
        }
        self.namespaces[5] = {
            '_default': u'Uncyclopedia talk',
	    'ar': u'نقاش ويكيبيديا',
	    'ca': u'Valenciclopèdia Discussió',
            'cs': u'Necyklopedie diskuse',
            'da': u'Spademanns Leksikon diskussion',
            'de': u'Uncyclopedia Diskussion',
	    'el': u'Φρικηπαίδεια συζήτηση',
            'en': u'Uncyclopedia talk',
            'es': u'Inciclopedia Discusión',
	    'fi': u'Keskustelu Hikipediasta',
            'fr': u'Discussion Désencyclopédie',
            'he': u'שיחת איןציקלופדיה',
	    'it': u'Discussioni Nonciclopedia',
            'ko': u'Uncyclopedia토론',
	    'la': u'Disputatio Uncapaediae',
            'nl': u'Overleg Onziclopedie',
	    'nn': u'Ikkepedia-diskusjon',
	    'no': u'Ikkepedia-diskusjon',
            'pl': u'Dyskusja Nonsensopedia',
            'pt': u'Desciclopédia Discussão',
	    'ru': u'Обсуждение Абсурдопедии',
            'sr': u'Разговор о Нециклопедија',
	    'sv': u'Psykelopedindiskussion',
	    'zh': u'伪基百科 talk',
	    'zh-tw': u'偽基百科討論',
        }

	self.namespaces[6] = {
	    '_default': u'Image',
            'ar': u'صورة',
	    'ca': u'Imatge',
            'cs': u'Soubor',
	    'da': u'Billede',
	    'de': u'Bild',
	    'el': u'Εικόνα',
	    'es': u'Imagen',
	    'fi': u'Kuva',
	    'he': u'תמונה',
	    'it': u'Immagine',
            'ko': u'그림',
	    'la': u'Imago',
            'nl': u'Afbeelding',
	    'nn': u'Bilde',
	    'no': u'Bilde',
	    'pl': u'Grafika',
	    'pt': u'Imagem',
	    'ru': u'Изображение',
            'sr': u'Слика',
	    'sv': u'Bild',
	    'zh-tw': u'圖像',
	}

	self.namespaces[7] = {
	    '_default': u'Image talk',
            'ar': u'نقاش الصورة',
	    'ca': u'Imatge Discussió',
            'cs': u'Soubor diskuse',
	    'da': u'Billede diskussion',
	    'de': u'Bild Diskussion',
	    'el': u'Συζήτηση εικόνας',
	    'es': u'Imagen Discusión',
	    'fi': u'Keskustelu kuvasta',
	    'fr': u'Discussion Image',
	    'he': u'שיחת תמונה',
	    'it': u'Discussioni immagine',
            'ko': u'그림토론',
	    'la': u'Disputatio Imaginis',
            'nl': u'Overleg afbeelding',
	    'nn': u'Bildediskusjon',
	    'no': u'Bildediskusjon',
	    'pl': u'Dyskusja grafiki',
	    'pt': u'Imagem Discussão',
	    'ru': u'Обсуждение изображения',
            'sr': u'Разговор о слици',
	    'sv': u'Bilddiskussion',
	    'zh-tw': u'圖像討論',
	}

        self.namespaces[8] = {
            '_default': u'MediaWiki',
            'ar': u'ميدياويكي',
            'he': u'מדיה ויקי',            
	    'zh-tw': u'媒體維基',
	}

        self.namespaces[9] = {
            '_default': u'MediaWiki talk',
            'ar': u'نقاش ميدياويكي',
	    'ca': u'MediaWiki Discussió',
            'cs': u'MediaWiki diskuse',
            'da': u'MediaWiki diskussion',
	    'de': u'MediaWiki Diskussion',
	    'es': u'MediaWiki Discusión',
	    'fr': u'Discussion MediaWiki',
            'he': u'שיחת מדיה ויקי',
	    'it': u'Discussioni MediaWiki',
            'ko': u'MediaWiki토론',
	    'la': u'Disputatio MediaWiki',
            'nl': u'Overleg MediaWiki',
	    'nn': u'MediaWiki-diskusjon',
	    'no': u'MediaWiki-diskusjon',
	    'pl': u'Dyskusja MediaWiki',
            'pt': u'MediaWiki Discussão',
            'ru': u'Обсуждение MediaWiki',
	    'sv': u'MediaWiki diskussion',
	    'zh-tw': u'媒體維基討論',
	}

        #
        # Custom namespace list for en: (and fi:)
        #
        self.namespaces[100] = {
	    '_default':u'Wilde',
	    'en':u'Wilde',
	    'fi':u'Hikiquote',
	}
        self.namespaces[101] = {
	    '_default':u'Wilde talk',
	    'en':u'Wilde talk',
	    'fi':u'Hiktionary'
	}
        self.namespaces[102] = {
	    '_default':u'UnNews',
	    'en':u'UnNews',
	    'fi':u'Hikikirjasto'
	}
        self.namespaces[103] = {'_default':u'UnNews talk'}
        self.namespaces[104] = {'_default':u'Undictionary'}
        self.namespaces[105] = {'_default':u'Undictionary talk'}
        self.namespaces[106] = {'_default':u'Game'}
        self.namespaces[107] = {'_default':u'Game talk'}
        self.namespaces[108] = {'_default':u'Babel'}
        self.namespaces[109] = {'_default':u'Babel talk'}
        self.namespaces[110] = {'_default':u'Forum'}
        self.namespaces[111] = {'_default':u'Forum talk'}

        # A few selected big languages for things that we do not want to loop over
        # all languages. This is only needed by the titletranslate.py module, so
        # if you carefully avoid the options, you could get away without these
        # for another wiki family.
        self.languages_by_size = ['en', 'pl', 'de', 'es', 'ru', 'fr']

    def hostname(self,code):
        return self.langs[code]

    def path(self, code):
        if code=='cs':
           return '/index.php'
        if code=='ko':
           return '/index.php'
        if code=='pt':
           return '/index.php'
        if code=='sv':
           return '/w/index.php'
        return '/wiki/index.php'

    def version(self, code):
        return "1.7"
